<?php

namespace App\models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CompanyUser extends Model 
{

    protected $table = 'company_users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function company()
    {
        return $this->belongsTo('App\models\Company');
    }

    public function roles()
    {
        return $this->belongsToMany('App\models\Role')withPivot('user_id','role_id');
    }

}